<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
require 'vendor/autoload.php';
class Stripe_original_module extends CI_Controller 
{
	var $currentUser='';
	var $service="payments";
	function __construct()
	{
		parent::__construct();
		$this->load->model('payment_model');
		$this->load->model('orders/orders_model');
		$this->load->model('orders/transaction_model');
		$this->load->model('orders/order_log_model');
		$this->load->model('ashrams/ashrams_trust_accounts_model');
		$this->load->library("userutil");

		if(isset($_GET['app']))
		{
			$this->load->library("server");
	        $this->server->require_scope("user");
	        $this->load->model('currencies_model');
	        $this->load->model('oauth_sessions_model');
	        $this->oauth_sessions_model->session_check();
		}
		if($this->session->userdata('loggedIn'))
		{
			if($this->session->userdata('id'))
				$this->currentUser=$this->session->userdata('admin_data');
			else
				$this->currentUser=$this->session->userdata('user_data');
		}
	}

	public function test()
	{
		\Stripe\Stripe::setApiKey('sk_test_vJ0z9DPm7e9ioSew7Y5VHjnc');
		$subscription = \Stripe\Subscription::retrieve("sub_DrvG3eB05hR9G1");
		print_r($subscription);
		//$subscription->plan ='plan_DrvCuzA1oYeM6k';
		//$subscription->save();
		\Stripe\Subscription::update('sub_49ty4767H20z6a', [
		  'cancel_at_period_end' => false,
		  'items' => [
		        [
		            //'id' => $subscription->items->data[0]->id,
		            'plan' => 'plan_DrvCuzA1oYeM6k',
		        ],
		    ],
		]);
	}
	public function capture()
	{
		if($this->input->post("reference")!='')
		{
			if(!$this->input->post("reference") || $this->input->post("reference")=='' || $this->input->post("stripeToken")=='' ||
				$this->input->post("stripeEmail")=='')
			{
				exit;
			}
			$reference=$this->input->post("reference");
			$tempInfo=$this->payment_model->getTempInfo($reference);
			if(!empty($tempInfo))
			{
				$customData=unserialize($tempInfo->data);

				//Get trust data
				$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($customData['formData']['ashram_id'],$customData['cart_type']);
		    	$trustsArray=array();
		    	foreach ($trusts as $trustData)
		    	{
		    		$trustsArray[$trustData->currency]=$trustData;
		    	}
		    	$trustData=$trustsArray[$tempInfo->currency];
				//Get trust data

				$orderId=0;
	    		if(isset($customData['order_id']))
	    			$orderId=$customData['order_id'];
				

				\Stripe\Stripe::setApiKey($trustData->stripe_secret_key);
				$charge = \Stripe\Charge::create(array(
						"amount" => $tempInfo->amount*100,
						"currency" => $tempInfo->currency,
						"source" => $this->input->post("stripeToken")
					));

				$txnid=$charge->balance_transaction;
				$this->payment_model->createTransaction($txnid,$tempInfo->user_id,$reference,'captured',null,$orderId);
	    		$this->payment_model->tempInfoUpdateTx($reference,$txnid,$tempInfo->amount);
	    		$this->payment_model->updateStripeTransaction($txnid,$charge);

	    		$transaction=new stdClass();
				$transaction->tx=$txnid;
				$tempIpn=new stdClass();
				$tempIpn->status='captured';
				$tempIpn->amount=$tempInfo->amount;
				if(isset($customData['cartData']))
				{
					$orderId=$this->payment_model->processPurchase($reference,$transaction,$tempInfo,$tempIpn);
					$this->orders_model->sendTransactionReceiptEmail($orderId,$transaction->tx);
				}
				else
				{
					$this->orders_model->calculateDue($orderId);
					$this->order_log_model->log($orderId,"Paid amount: ".strtoupper($tempInfo->currency)." ".$tempInfo->amount."\nStripe\nTx ID:".$txnid);
				}

				$transactionRecord=$this->payment_model->getTransaction($txnid);
				$return['redirect_url']=$transactionRecord->redirect_url;
				$return['order_id']=$transactionRecord->order_id;

				if(isset($customData['cartData']))
				{
					$this->session->set_userdata("order_placed",1);
					if($this->input->post("order_type")==1)
						$this->cart_log_model->log("Payment success:Stripe",$this->session->userdata("poojasCartAshramId"),$this->input->post("order_type"));
					if($this->input->post("order_type")==2)
						$this->cart_log_model->log("Payment success:Stripe",$this->session->userdata("donationCartAshramId"),$this->input->post("order_type"));
					if($this->input->post("order_type")==3)
						$this->cart_log_model->log("Payment success:Stripe",$this->session->userdata("storeCartAshramId"),$this->input->post("order_type"));
				}
				else
				{
					$this->orders_model->sendTransactionReceiptEmail($orderId,$txnid);
					$this->session->set_userdata("payment_success","Payment processed successfully.");
				}
				header('Content-Type: application/json');
				echo json_encode($return);
				/*if(isset($customData['cartData']))
					redirect($return['redirect_url']);
				else
				{
					header('Content-Type: application/json');
					echo json_encode($return);
					//redirect($tempInfo->redirect_url);
				}*/
			}
		}
	}
	public function pay()
	{
		if(isset($_POST['stripeToken']))
		{
			\Stripe\Stripe::setApiKey('sk_test_vJ0z9DPm7e9ioSew7Y5VHjnc');
			$charge = \Stripe\Charge::create(array(
					"amount" => 2300,
					"currency" => "usd",
					"source" => $_POST['stripeToken'],
					"description" => "Charge for Dattapeetham Poojas"
				));
			print_r($charge);
		}
		else
		{
			?>
			<script src="https://checkout.stripe.com/checkout.js"></script>

			<button id="customButton">Purchase</button>

			<script>
			var handler = StripeCheckout.configure({
			  key: 'pk_test_g6do5S237ekq10r65BnxO6S0',
			  image: '<?php echo aws_s3_base_url;?>/images/sample_datta_logo.jpg',
			  locale: 'auto',
			  closed:function()
			    {
			    	console.log("closed");
			    },

			    opened:function()
			    {
			    	console.log(r);
			    	console.log("Opened");
			    },
			    token:function(source)
			    {
			    	console.log("Token here");
			    	console.log(source);
			    	//console.log(args);
			    }
			});

			document.getElementById('customButton').addEventListener('click', function(e) {
			  	// Open Checkout with further options:
			  	handler.open({
				    name: '<?php echo site_name_string1;?>',
				    description: 'Poojas',
				    amount: 2000,
			  	});
			  	e.preventDefault();
			});

			// Close Checkout on page navigation:
			window.addEventListener('popstate', function() {
			  handler.close();
			});
			</script>

			<!-- <form action="" method="post">
				<script src="https://checkout.stripe.com/checkout.js" class="stripe-button"
			          data-key="pk_test_b5j58orEjB5EUyaIkaSr6qq1"
			          data-currency="usd"
			          data-amount="2300"></script>
			</form> -->
			<?PHP
		}	
	}
	
}
?>